ldfps = 170100^tst
/
/
/	arctangent routine - atan(1/n) by a modified form of
/	a series due originally, I think, to LaGrange.
/
/	atan(1/n) = (n*z)[1 + (2/3)z + (2/3)(4/5)z^2 + ...
/
/	where  z = 1/(n^2+1)
/
/
/	miscellaneous initialization
/
nsiz = 1000.
csiz = 256.
/
	ldfps	$7600		/set di modes
	jsr	pc,init
	movif	p,fr0
	movf	fr0,fr1
	mulf	fr0,fr0
	addf	$one,fr0
	mulf	$half,fr0
	movf	fr0,psqo2
/
/	set up numerators
/
	setl
	mov	$nsiz,r0
	mov	$num1,r1
	mov	$num2,r2
1:
	movfo	fr1,(r1)+
	clr	(r2)+
	clr	(r2)+
	sob	r0,1b
/
/
/	outer loop - read in a new block of carries
/
l1:
	jsr	pc,rtape
	movif	term,fr0
	movf	fr0,iterm
	mulf	$two,fr0
	subf	$one,fr0
	movf	fr0,iden		/den = 2*term - 1
	mov	$num1,r2
	mov	$num2,r4
	mov	$nsiz,r3
/
/
/	middle loop - use a new denominator and numerator
/
l2:
	movof	(r2),fr0
	movf	fr0,fr2		/fr2 = num1
	movof	(r4),fr0
	movf	fr0,fr3		/fr3 = num2
/
	movf	$one,fr1
	divf	iden,fr1
	movf	fr1,q1		/ 1/iden
	movf	iden,fr1
	addf	$half,fr1
	movf	fr1,q2		/ iden+.5
/
	movf	$one,fr1
	divf	psqo2,fr1
	movf	fr1,q3		/ 1/psqo2
	movf	psqo2,fr1
	addf	$half,fr1
	movf	fr1,q4		/ psqo2+.5
/
	movf	tene8,fr0
	movf	fr0,fr4
	mov	$tapeb,r5
	mov	$csiz,r0
/
/
/	inner loop - process another carry
/	produce new carry and numerators
/
l3:
/
/	num1*1e8 + iterm*carry
/	divide by 2*term-1
/	save Q ; remainder back to num1
/
	movif	(r5),fr0		/carry
	mulf	iterm,fr0
	mulf	fr4,fr2			/ 1e8*num1
	addf	fr2,fr0
	modf	q1,fr0
	movf	fr1,fr5			/quotient
	mulf	q2,fr0
	modf	$one,fr0
	movf	fr1,fr2			/remainder
/
/	num2*1e8 + Q
/	divide by (p^2+1)/2
/	Q to carry - remainder back to num2
/
	movf	fr3,fr0			/num2
	mulf	fr4,fr0
	addf	fr5,fr0			/quotient from above
	modf	q3,fr0
	movfi	fr1,(r5)+		/quotient
	mulf	q4,fr0
	modf	$one,fr0
	movf	fr1,fr3
	sob	r0,l3
/
/
/	store numerators; decrement term number and denominator
/	go back to middle loop
/
	movfo	fr2,(r2)+
	movfo	fr3,(r4)+
/
	movf	iterm,fr0
	subf	$one,fr0
	movf	fr0,iterm
	movf	iden,fr0
	subf	$two,fr0
	movf	fr0,iden
	dec	r3
	bne	l2
/
/
	jsr	pc,wtape
	dec	nblks
	bgt	l1
	jmp	termx
/
/
half	= 40000
one	= 40200
two	= 40400
/
	.text
tene8:	46676;136040;0;0
/
	.bss
num1:	.=.+[nsiz*4.]
num2:	.=.+[nsiz*4.]
psqo2:	.=.+8
iterm:	.=.+8
iden:	.=.+8
q1:	.=.+8
q2:	.=.+8
q3:	.=.+8
q4:	.=.+8
	.text
